/* SPDX-License-Identifier: GPL-2.0 */

#ifndef __MEDIA_I2C_DS90UB953_H__
#define __MEDIA_I2C_DS90UB953_H__

#include <linux/types.h>

#define UB953_REG_RESET_CTL			0x01
#define UB953_REG_RESET_CTL_DIGITAL_RESET_1	BIT(1)
#define UB953_REG_RESET_CTL_DIGITAL_RESET_0	BIT(0)

#define UB953_REG_GENERAL_CFG			0x02
#define UB953_REG_GENERAL_CFG_CONT_CLK		BIT(6)
#define UB953_REG_GENERAL_CFG_CSI_LANE_SEL_SHIFT	4
#define UB953_REG_GENERAL_CFG_CSI_LANE_SEL_MASK	GENMASK(5, 4)
#define UB953_REG_GENERAL_CFG_CRC_TX_GEN_ENABLE	BIT(1)
#define UB953_REG_GENERAL_CFG_I2C_STRAP_MODE	BIT(0)

#define UB953_REG_MODE_SEL			0x03
#define UB953_REG_MODE_SEL_MODE_DONE		BIT(3)
#define UB953_REG_MODE_SEL_MODE_OVERRIDE	BIT(4)
#define UB953_REG_MODE_SEL_MODE_MASK		GENMASK(2, 0)

#define UB953_REG_CLKOUT_CTRL0			0x06
#define UB953_REG_CLKOUT_CTRL1			0x07

#define UB953_REG_I2C_CONTROL2			0x0a
#define UB953_REG_I2C_CONTROL2_SDA_OUTPUT_SETUP_SHIFT	4
#define UB953_REG_I2C_CONTROL2_BUS_SPEEDUP	BIT(1)

#define UB953_REG_SCL_HIGH_TIME			0x0b
#define UB953_REG_SCL_LOW_TIME			0x0c

#define UB953_REG_LOCAL_GPIO_DATA		0x0d
#define UB953_REG_LOCAL_GPIO_DATA_GPIO_RMTEN(n)		BIT(4 + (n))
#define UB953_REG_LOCAL_GPIO_DATA_GPIO_OUT_SRC(n)	BIT(0 + (n))

#define UB953_REG_GPIO_INPUT_CTRL		0x0e
#define UB953_REG_GPIO_INPUT_CTRL_OUT_EN(n)	BIT(4 + (n))
#define UB953_REG_GPIO_INPUT_CTRL_INPUT_EN(n)	BIT(0 + (n))

#define UB953_REG_BC_CTRL			0x49
#define UB953_REG_BC_CTRL_CRC_ERR_CLR		BIT(3)

#define UB953_REG_REV_MASK_ID			0x50
#define UB953_REG_GENERAL_STATUS		0x52

#define UB953_REG_GPIO_PIN_STS			0x53
#define UB953_REG_GPIO_PIN_STS_GPIO_STS(n)	BIT(0 + (n))

#define UB953_REG_BIST_ERR_CNT			0x54
#define UB953_REG_CRC_ERR_CNT1			0x55
#define UB953_REG_CRC_ERR_CNT2			0x56

#define UB953_REG_CSI_ERR_CNT			0x5c
#define UB953_REG_CSI_ERR_STATUS		0x5d
#define UB953_REG_CSI_ERR_DLANE01		0x5e
#define UB953_REG_CSI_ERR_DLANE23		0x5f
#define UB953_REG_CSI_ERR_CLK_LANE		0x60
#define UB953_REG_CSI_PKT_HDR_VC_ID		0x61
#define UB953_REG_PKT_HDR_WC_LSB		0x62
#define UB953_REG_PKT_HDR_WC_MSB		0x63
#define UB953_REG_CSI_ECC			0x64

#define UB953_REG_IND_ACC_CTL			0xb0
#define UB953_REG_IND_ACC_ADDR			0xb1
#define UB953_REG_IND_ACC_DATA			0xb2

#define UB953_REG_FPD3_RX_ID(n)			(0xf0 + (n))
#define UB953_REG_FPD3_RX_ID_LEN		6

/* Indirect register blocks */
#define UB953_IND_TARGET_PAT_GEN		0x00
#define UB953_IND_TARGET_ANALOG			0x01
#define UB953_IND_TARGET_DIE_ID			0x02

#define UB953_IND_PGEN_CTL			0x01
#define UB953_IND_PGEN_CTL_PGEN_ENABLE		BIT(0)
#define UB953_IND_PGEN_CFG			0x02
#define UB953_IND_PGEN_CSI_DI			0x03
#define UB953_IND_PGEN_LINE_SIZE1		0x04
#define UB953_IND_PGEN_LINE_SIZE0		0x05
#define UB953_IND_PGEN_BAR_SIZE1		0x06
#define UB953_IND_PGEN_BAR_SIZE0		0x07
#define UB953_IND_PGEN_ACT_LPF1			0x08
#define UB953_IND_PGEN_ACT_LPF0			0x09
#define UB953_IND_PGEN_TOT_LPF1			0x0a
#define UB953_IND_PGEN_TOT_LPF0			0x0b
#define UB953_IND_PGEN_LINE_PD1			0x0c
#define UB953_IND_PGEN_LINE_PD0			0x0d
#define UB953_IND_PGEN_VBP			0x0e
#define UB953_IND_PGEN_VFP			0x0f
#define UB953_IND_PGEN_COLOR(n)			(0x10 + (n)) /* n <= 15 */

#define UB953_IND_ANA_TEMP_DYNAMIC_CFG		0x4b
#define UB953_IND_ANA_TEMP_DYNAMIC_CFG_OV	BIT(5)
#define UB953_IND_ANA_TEMP_STATIC_CFG		0x4c
#define UB953_IND_ANA_TEMP_STATIC_CFG_MASK	GENMASK(6, 4)

/* UB971 Registers */

#define UB971_ENH_BC_CHK			0x4b

#endif /* __MEDIA_I2C_DS90UB953_H__ */
