/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_DESCRIPTOR_HEAP_H
#define VN_PROTOCOL_DRIVER_DESCRIPTOR_HEAP_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkWriteSamplerDescriptorsEXT
 *   vkWriteResourceDescriptorsEXT
 */

/* struct VkHostAddressRangeEXT */

static inline size_t
vn_sizeof_VkHostAddressRangeEXT(const VkHostAddressRangeEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_size_t(&val->size);
    if (val->address) {
        size += vn_sizeof_array_size(val->size);
        size += vn_sizeof_blob_array(val->address, val->size);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline void
vn_encode_VkHostAddressRangeEXT(struct vn_cs_encoder *enc, const VkHostAddressRangeEXT *val)
{
    vn_encode_size_t(enc, &val->size);
    if (val->address) {
        vn_encode_array_size(enc, val->size);
        vn_encode_blob_array(enc, val->address, val->size);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_decode_VkHostAddressRangeEXT(struct vn_cs_decoder *dec, VkHostAddressRangeEXT *val)
{
    vn_decode_size_t(dec, &val->size);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->size);
        vn_decode_blob_array(dec, val->address, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->address = NULL;
    }
}

static inline size_t
vn_sizeof_VkHostAddressRangeEXT_partial(const VkHostAddressRangeEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_size_t(&val->size);
    size += vn_sizeof_simple_pointer(val->address); /* out */
    return size;
}

static inline void
vn_encode_VkHostAddressRangeEXT_partial(struct vn_cs_encoder *enc, const VkHostAddressRangeEXT *val)
{
    vn_encode_size_t(enc, &val->size);
    vn_encode_array_size(enc, val->address ? val->size : 0); /* out */
}

/* struct VkImageDescriptorInfoEXT chain */

static inline size_t
vn_sizeof_VkImageDescriptorInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageDescriptorInfoEXT_self(const VkImageDescriptorInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_simple_pointer(val->pView);
    if (val->pView)
        size += vn_sizeof_VkImageViewCreateInfo(val->pView);
    size += vn_sizeof_VkImageLayout(&val->layout);
    return size;
}

static inline size_t
vn_sizeof_VkImageDescriptorInfoEXT(const VkImageDescriptorInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageDescriptorInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkImageDescriptorInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkImageDescriptorInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageDescriptorInfoEXT_self(struct vn_cs_encoder *enc, const VkImageDescriptorInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    if (vn_encode_simple_pointer(enc, val->pView))
        vn_encode_VkImageViewCreateInfo(enc, val->pView);
    vn_encode_VkImageLayout(enc, &val->layout);
}

static inline void
vn_encode_VkImageDescriptorInfoEXT(struct vn_cs_encoder *enc, const VkImageDescriptorInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_DESCRIPTOR_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_DESCRIPTOR_INFO_EXT });
    vn_encode_VkImageDescriptorInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkImageDescriptorInfoEXT_self(enc, val);
}

/* struct VkTexelBufferDescriptorInfoEXT chain */

static inline size_t
vn_sizeof_VkTexelBufferDescriptorInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkTexelBufferDescriptorInfoEXT_self(const VkTexelBufferDescriptorInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkDeviceAddressRangeEXT(&val->addressRange);
    return size;
}

static inline size_t
vn_sizeof_VkTexelBufferDescriptorInfoEXT(const VkTexelBufferDescriptorInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkTexelBufferDescriptorInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkTexelBufferDescriptorInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkTexelBufferDescriptorInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkTexelBufferDescriptorInfoEXT_self(struct vn_cs_encoder *enc, const VkTexelBufferDescriptorInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkDeviceAddressRangeEXT(enc, &val->addressRange);
}

static inline void
vn_encode_VkTexelBufferDescriptorInfoEXT(struct vn_cs_encoder *enc, const VkTexelBufferDescriptorInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_TEXEL_BUFFER_DESCRIPTOR_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_TEXEL_BUFFER_DESCRIPTOR_INFO_EXT });
    vn_encode_VkTexelBufferDescriptorInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkTexelBufferDescriptorInfoEXT_self(enc, val);
}

/* struct VkTensorViewCreateInfoARM chain */

static inline size_t
vn_sizeof_VkTensorViewCreateInfoARM_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkTensorViewCreateInfoARM_self(const VkTensorViewCreateInfoARM *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags64(&val->flags);
    size += vn_sizeof_VkTensorARM(&val->tensor);
    size += vn_sizeof_VkFormat(&val->format);
    return size;
}

static inline size_t
vn_sizeof_VkTensorViewCreateInfoARM(const VkTensorViewCreateInfoARM *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkTensorViewCreateInfoARM_pnext(val->pNext);
    size += vn_sizeof_VkTensorViewCreateInfoARM_self(val);

    return size;
}

static inline void
vn_encode_VkTensorViewCreateInfoARM_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkTensorViewCreateInfoARM_self(struct vn_cs_encoder *enc, const VkTensorViewCreateInfoARM *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags64(enc, &val->flags);
    vn_encode_VkTensorARM(enc, &val->tensor);
    vn_encode_VkFormat(enc, &val->format);
}

static inline void
vn_encode_VkTensorViewCreateInfoARM(struct vn_cs_encoder *enc, const VkTensorViewCreateInfoARM *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_TENSOR_VIEW_CREATE_INFO_ARM);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_TENSOR_VIEW_CREATE_INFO_ARM });
    vn_encode_VkTensorViewCreateInfoARM_pnext(enc, val->pNext);
    vn_encode_VkTensorViewCreateInfoARM_self(enc, val);
}

/* union VkResourceDescriptorDataEXT */

static inline size_t
vn_sizeof_VkResourceDescriptorDataEXT(const VkResourceDescriptorDataEXT *val, VkDescriptorType tag)
{
    size_t size = vn_sizeof_VkDescriptorType(&tag);
    switch (tag) {
    case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        size += vn_sizeof_simple_pointer(val->pImage);
        if (val->pImage)
            size += vn_sizeof_VkImageDescriptorInfoEXT(val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        size += vn_sizeof_simple_pointer(val->pImage);
        if (val->pImage)
            size += vn_sizeof_VkImageDescriptorInfoEXT(val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        size += vn_sizeof_simple_pointer(val->pImage);
        if (val->pImage)
            size += vn_sizeof_VkImageDescriptorInfoEXT(val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM:
        size += vn_sizeof_simple_pointer(val->pImage);
        if (val->pImage)
            size += vn_sizeof_VkImageDescriptorInfoEXT(val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM:
        size += vn_sizeof_simple_pointer(val->pImage);
        if (val->pImage)
            size += vn_sizeof_VkImageDescriptorInfoEXT(val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        size += vn_sizeof_simple_pointer(val->pTexelBuffer);
        if (val->pTexelBuffer)
            size += vn_sizeof_VkTexelBufferDescriptorInfoEXT(val->pTexelBuffer);
        break;
    case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        size += vn_sizeof_simple_pointer(val->pTexelBuffer);
        if (val->pTexelBuffer)
            size += vn_sizeof_VkTexelBufferDescriptorInfoEXT(val->pTexelBuffer);
        break;
    case VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR:
        size += vn_sizeof_simple_pointer(val->pAddressRange);
        if (val->pAddressRange)
            size += vn_sizeof_VkDeviceAddressRangeEXT(val->pAddressRange);
        break;
    case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        size += vn_sizeof_simple_pointer(val->pAddressRange);
        if (val->pAddressRange)
            size += vn_sizeof_VkDeviceAddressRangeEXT(val->pAddressRange);
        break;
    case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        size += vn_sizeof_simple_pointer(val->pAddressRange);
        if (val->pAddressRange)
            size += vn_sizeof_VkDeviceAddressRangeEXT(val->pAddressRange);
        break;
    case VK_DESCRIPTOR_TYPE_TENSOR_ARM:
        size += vn_sizeof_simple_pointer(val->pTensorARM);
        if (val->pTensorARM)
            size += vn_sizeof_VkTensorViewCreateInfoARM(val->pTensorARM);
        break;
    default:
        assert(false);
        break;
    }
    return size;
}

static inline void
vn_encode_VkResourceDescriptorDataEXT(struct vn_cs_encoder *enc, const VkResourceDescriptorDataEXT *val, VkDescriptorType tag)
{
    vn_encode_VkDescriptorType(enc, &tag);
    switch (tag) {
    case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        if (vn_encode_simple_pointer(enc, val->pImage))
            vn_encode_VkImageDescriptorInfoEXT(enc, val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        if (vn_encode_simple_pointer(enc, val->pImage))
            vn_encode_VkImageDescriptorInfoEXT(enc, val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (vn_encode_simple_pointer(enc, val->pImage))
            vn_encode_VkImageDescriptorInfoEXT(enc, val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM:
        if (vn_encode_simple_pointer(enc, val->pImage))
            vn_encode_VkImageDescriptorInfoEXT(enc, val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM:
        if (vn_encode_simple_pointer(enc, val->pImage))
            vn_encode_VkImageDescriptorInfoEXT(enc, val->pImage);
        break;
    case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        if (vn_encode_simple_pointer(enc, val->pTexelBuffer))
            vn_encode_VkTexelBufferDescriptorInfoEXT(enc, val->pTexelBuffer);
        break;
    case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (vn_encode_simple_pointer(enc, val->pTexelBuffer))
            vn_encode_VkTexelBufferDescriptorInfoEXT(enc, val->pTexelBuffer);
        break;
    case VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR:
        if (vn_encode_simple_pointer(enc, val->pAddressRange))
            vn_encode_VkDeviceAddressRangeEXT(enc, val->pAddressRange);
        break;
    case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        if (vn_encode_simple_pointer(enc, val->pAddressRange))
            vn_encode_VkDeviceAddressRangeEXT(enc, val->pAddressRange);
        break;
    case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        if (vn_encode_simple_pointer(enc, val->pAddressRange))
            vn_encode_VkDeviceAddressRangeEXT(enc, val->pAddressRange);
        break;
    case VK_DESCRIPTOR_TYPE_TENSOR_ARM:
        if (vn_encode_simple_pointer(enc, val->pTensorARM))
            vn_encode_VkTensorViewCreateInfoARM(enc, val->pTensorARM);
        break;
    default:
        assert(false);
        break;
    }
}

/* struct VkResourceDescriptorInfoEXT chain */

static inline size_t
vn_sizeof_VkResourceDescriptorInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkResourceDescriptorInfoEXT_self(const VkResourceDescriptorInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDescriptorType(&val->type);
    size += vn_sizeof_VkResourceDescriptorDataEXT(&val->data, val->type);
    return size;
}

static inline size_t
vn_sizeof_VkResourceDescriptorInfoEXT(const VkResourceDescriptorInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkResourceDescriptorInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkResourceDescriptorInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkResourceDescriptorInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkResourceDescriptorInfoEXT_self(struct vn_cs_encoder *enc, const VkResourceDescriptorInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkDescriptorType(enc, &val->type);
    vn_encode_VkResourceDescriptorDataEXT(enc, &val->data, val->type);
}

static inline void
vn_encode_VkResourceDescriptorInfoEXT(struct vn_cs_encoder *enc, const VkResourceDescriptorInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RESOURCE_DESCRIPTOR_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RESOURCE_DESCRIPTOR_INFO_EXT });
    vn_encode_VkResourceDescriptorInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkResourceDescriptorInfoEXT_self(enc, val);
}

static inline size_t vn_sizeof_vkRegisterCustomBorderColorEXT(VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkRegisterCustomBorderColorEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pBorderColor);
    if (pBorderColor)
        cmd_size += vn_sizeof_VkSamplerCustomBorderColorCreateInfoEXT(pBorderColor);
    cmd_size += vn_sizeof_VkBool32(&requestIndex);
    cmd_size += vn_sizeof_simple_pointer(pIndex);
    if (pIndex)
        cmd_size += vn_sizeof_uint32_t(pIndex);

    return cmd_size;
}

static inline void vn_encode_vkRegisterCustomBorderColorEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkRegisterCustomBorderColorEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pBorderColor))
        vn_encode_VkSamplerCustomBorderColorCreateInfoEXT(enc, pBorderColor);
    vn_encode_VkBool32(enc, &requestIndex);
    if (vn_encode_simple_pointer(enc, pIndex))
        vn_encode_uint32_t(enc, pIndex);
}

static inline size_t vn_sizeof_vkRegisterCustomBorderColorEXT_reply(VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkRegisterCustomBorderColorEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pBorderColor */
    /* skip requestIndex */
    cmd_size += vn_sizeof_simple_pointer(pIndex);
    if (pIndex)
        cmd_size += vn_sizeof_uint32_t(pIndex);

    return cmd_size;
}

static inline VkResult vn_decode_vkRegisterCustomBorderColorEXT_reply(struct vn_cs_decoder *dec, VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkRegisterCustomBorderColorEXT_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pBorderColor */
    /* skip requestIndex */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint32_t(dec, pIndex);
    } else {
        pIndex = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkUnregisterCustomBorderColorEXT(VkDevice device, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkUnregisterCustomBorderColorEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&index);

    return cmd_size;
}

static inline void vn_encode_vkUnregisterCustomBorderColorEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkUnregisterCustomBorderColorEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &index);
}

static inline size_t vn_sizeof_vkUnregisterCustomBorderColorEXT_reply(VkDevice device, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkUnregisterCustomBorderColorEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip index */

    return cmd_size;
}

static inline void vn_decode_vkUnregisterCustomBorderColorEXT_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t index)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkUnregisterCustomBorderColorEXT_EXT);

    /* skip device */
    /* skip index */
}

static inline size_t vn_sizeof_vkGetImageOpaqueCaptureDataEXT(VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageOpaqueCaptureDataEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_uint32_t(&imageCount);
    if (pImages) {
        cmd_size += vn_sizeof_array_size(imageCount);
        for (uint32_t i = 0; i < imageCount; i++)
            cmd_size += vn_sizeof_VkImage(&pImages[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pDatas) {
        cmd_size += vn_sizeof_array_size(imageCount);
        for (uint32_t i = 0; i < imageCount; i++)
            cmd_size += vn_sizeof_VkHostAddressRangeEXT_partial(&pDatas[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkGetImageOpaqueCaptureDataEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageOpaqueCaptureDataEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_uint32_t(enc, &imageCount);
    if (pImages) {
        vn_encode_array_size(enc, imageCount);
        for (uint32_t i = 0; i < imageCount; i++)
            vn_encode_VkImage(enc, &pImages[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pDatas) {
        vn_encode_array_size(enc, imageCount);
        for (uint32_t i = 0; i < imageCount; i++)
            vn_encode_VkHostAddressRangeEXT_partial(enc, &pDatas[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkGetImageOpaqueCaptureDataEXT_reply(VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetImageOpaqueCaptureDataEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip imageCount */
    /* skip pImages */
    if (pDatas) {
        cmd_size += vn_sizeof_array_size(imageCount);
        for (uint32_t i = 0; i < imageCount; i++)
            cmd_size += vn_sizeof_VkHostAddressRangeEXT(&pDatas[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkGetImageOpaqueCaptureDataEXT_reply(struct vn_cs_decoder *dec, VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetImageOpaqueCaptureDataEXT_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip imageCount */
    /* skip pImages */
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, imageCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkHostAddressRangeEXT(dec, &pDatas[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        pDatas = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkWriteSamplerDescriptorMESA(VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteSamplerDescriptorMESA_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pSampler);
    if (pSampler)
        cmd_size += vn_sizeof_VkSamplerCreateInfo(pSampler);
    cmd_size += vn_sizeof_size_t(&dataSize);
    cmd_size += vn_sizeof_simple_pointer(pData); /* out */

    return cmd_size;
}

static inline void vn_encode_vkWriteSamplerDescriptorMESA(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteSamplerDescriptorMESA_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pSampler))
        vn_encode_VkSamplerCreateInfo(enc, pSampler);
    vn_encode_size_t(enc, &dataSize);
    vn_encode_array_size(enc, pData ? dataSize : 0); /* out */
}

static inline size_t vn_sizeof_vkWriteSamplerDescriptorMESA_reply(VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteSamplerDescriptorMESA_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pSampler */
    /* skip dataSize */
    if (pData) {
        cmd_size += vn_sizeof_array_size(dataSize);
        cmd_size += vn_sizeof_blob_array(pData, dataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkWriteSamplerDescriptorMESA_reply(struct vn_cs_decoder *dec, VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkWriteSamplerDescriptorMESA_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pSampler */
    /* skip dataSize */
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, dataSize);
        vn_decode_blob_array(dec, pData, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        pData = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkWriteResourceDescriptorMESA(VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteResourceDescriptorMESA_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pResource);
    if (pResource)
        cmd_size += vn_sizeof_VkResourceDescriptorInfoEXT(pResource);
    cmd_size += vn_sizeof_size_t(&dataSize);
    cmd_size += vn_sizeof_simple_pointer(pData); /* out */

    return cmd_size;
}

static inline void vn_encode_vkWriteResourceDescriptorMESA(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteResourceDescriptorMESA_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pResource))
        vn_encode_VkResourceDescriptorInfoEXT(enc, pResource);
    vn_encode_size_t(enc, &dataSize);
    vn_encode_array_size(enc, pData ? dataSize : 0); /* out */
}

static inline size_t vn_sizeof_vkWriteResourceDescriptorMESA_reply(VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkWriteResourceDescriptorMESA_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pResource */
    /* skip dataSize */
    if (pData) {
        cmd_size += vn_sizeof_array_size(dataSize);
        cmd_size += vn_sizeof_blob_array(pData, dataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkWriteResourceDescriptorMESA_reply(struct vn_cs_decoder *dec, VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkWriteResourceDescriptorMESA_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pResource */
    /* skip dataSize */
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, dataSize);
        vn_decode_blob_array(dec, pData, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        pData = NULL;
    }

    return ret;
}

static inline void vn_submit_vkRegisterCustomBorderColorEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkRegisterCustomBorderColorEXT(device, pBorderColor, requestIndex, pIndex);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkRegisterCustomBorderColorEXT_reply(device, pBorderColor, requestIndex, pIndex) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkRegisterCustomBorderColorEXT(enc, cmd_flags, device, pBorderColor, requestIndex, pIndex);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkUnregisterCustomBorderColorEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t index, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkUnregisterCustomBorderColorEXT(device, index);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkUnregisterCustomBorderColorEXT_reply(device, index) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkUnregisterCustomBorderColorEXT(enc, cmd_flags, device, index);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetImageOpaqueCaptureDataEXT(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetImageOpaqueCaptureDataEXT(device, imageCount, pImages, pDatas);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetImageOpaqueCaptureDataEXT_reply(device, imageCount, pImages, pDatas) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetImageOpaqueCaptureDataEXT(enc, cmd_flags, device, imageCount, pImages, pDatas);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkWriteSamplerDescriptorMESA(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkWriteSamplerDescriptorMESA(device, pSampler, dataSize, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkWriteSamplerDescriptorMESA_reply(device, pSampler, dataSize, pData) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkWriteSamplerDescriptorMESA(enc, cmd_flags, device, pSampler, dataSize, pData);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkWriteResourceDescriptorMESA(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkWriteResourceDescriptorMESA(device, pResource, dataSize, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkWriteResourceDescriptorMESA_reply(device, pResource, dataSize, pData) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkWriteResourceDescriptorMESA(enc, cmd_flags, device, pResource, dataSize, pData);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkRegisterCustomBorderColorEXT(struct vn_ring *vn_ring, VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkRegisterCustomBorderColorEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pBorderColor, requestIndex, pIndex, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkRegisterCustomBorderColorEXT_reply(dec, device, pBorderColor, requestIndex, pIndex);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkRegisterCustomBorderColorEXT(struct vn_ring *vn_ring, VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkRegisterCustomBorderColorEXT(vn_ring, 0, device, pBorderColor, requestIndex, pIndex, &submit);
}

static inline void vn_async_vkUnregisterCustomBorderColorEXT(struct vn_ring *vn_ring, VkDevice device, uint32_t index)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkUnregisterCustomBorderColorEXT(vn_ring, 0, device, index, &submit);
}

static inline VkResult vn_call_vkGetImageOpaqueCaptureDataEXT(struct vn_ring *vn_ring, VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageOpaqueCaptureDataEXT(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, imageCount, pImages, pDatas, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkGetImageOpaqueCaptureDataEXT_reply(dec, device, imageCount, pImages, pDatas);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetImageOpaqueCaptureDataEXT(struct vn_ring *vn_ring, VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetImageOpaqueCaptureDataEXT(vn_ring, 0, device, imageCount, pImages, pDatas, &submit);
}

static inline VkResult vn_call_vkWriteSamplerDescriptorMESA(struct vn_ring *vn_ring, VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkWriteSamplerDescriptorMESA(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pSampler, dataSize, pData, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkWriteSamplerDescriptorMESA_reply(dec, device, pSampler, dataSize, pData);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkWriteSamplerDescriptorMESA(struct vn_ring *vn_ring, VkDevice device, const VkSamplerCreateInfo* pSampler, size_t dataSize, void* pData)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkWriteSamplerDescriptorMESA(vn_ring, 0, device, pSampler, dataSize, pData, &submit);
}

static inline VkResult vn_call_vkWriteResourceDescriptorMESA(struct vn_ring *vn_ring, VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkWriteResourceDescriptorMESA(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pResource, dataSize, pData, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkWriteResourceDescriptorMESA_reply(dec, device, pResource, dataSize, pData);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkWriteResourceDescriptorMESA(struct vn_ring *vn_ring, VkDevice device, const VkResourceDescriptorInfoEXT* pResource, size_t dataSize, void* pData)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkWriteResourceDescriptorMESA(vn_ring, 0, device, pResource, dataSize, pData, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_DESCRIPTOR_HEAP_H */
