/* Copyright 2026 Advanced Micro Devices, Inc.
 * SPDX-License-Identifier: MIT
 */

#ifndef PM4_IT_OPCODES_GFX12_H
#define PM4_IT_OPCODES_GFX12_H

enum IT_OpCodeType {
    IT_NOP                               = 0x10,
    IT_SET_BASE                          = 0x11,
    IT_CLEAR_STATE                       = 0x12,
    IT_INDEX_BUFFER_SIZE                 = 0x13,
    IT_DISPATCH_DIRECT                   = 0x15,
    IT_DISPATCH_INDIRECT                 = 0x16,
    IT_ATOMIC_MEM                        = 0x1E,
    IT_OCCLUSION_QUERY                   = 0x1F,
    IT_SET_PREDICATION                   = 0x20,
    IT_REG_RMW                           = 0x21,
    IT_COND_EXEC                         = 0x22,
    IT_PRED_EXEC                         = 0x23,
    IT_DRAW_INDIRECT                     = 0x24,
    IT_DRAW_INDEX_INDIRECT               = 0x25,
    IT_INDEX_BASE                        = 0x26,
    IT_DRAW_INDEX_2                      = 0x27,
    IT_CONTEXT_CONTROL                   = 0x28,
    IT_DRAW_INDIRECT_MULTI               = 0x2C,
    IT_DRAW_INDEX_AUTO                   = 0x2D,
    IT_NUM_INSTANCES                     = 0x2F,
    IT_DRAW_INDEX_MULTI_AUTO             = 0x30,
    IT_DRAW_INDEX_OFFSET_2               = 0x35,
    IT_WRITE_DATA                        = 0x37,
    IT_DRAW_INDEX_INDIRECT_MULTI         = 0x38,
    IT_WAIT_REG_MEM                      = 0x3C,
    IT_PERF_COUNTER_WINDOW               = 0x3D,
    IT_INDIRECT_BUFFER                   = 0x3F,
    IT_COND_INDIRECT_BUFFER              = 0x3F,
    IT_COPY_DATA                         = 0x40,
    IT_PFP_SYNC_ME                       = 0x42,
    IT_COND_WRITE                        = 0x45,
    IT_EVENT_WRITE                       = 0x46,
    IT_RELEASE_MEM                       = 0x49,
    IT_PREAMBLE_CNTL                     = 0x4A,
    IT_DISPATCH_MESH_INDIRECT_MULTI      = 0x4C,
    IT_DISPATCH_TASKMESH_GFX             = 0x4D,
    IT_DISPATCH_MESH_DIRECT              = 0x4E,
    IT_DMA_DATA                          = 0x50,
    IT_CONTEXT_REG_RMW                   = 0x51,
    IT_PERFMON_CONTROL                   = 0x54,
    IT_ACQUIRE_MEM                       = 0x58,
    IT_REWIND                            = 0x59,
    IT_PRIME_UTCL2                       = 0x5D,
    IT_LOAD_UCONFIG_REG                  = 0x5E,
    IT_LOAD_SH_REG                       = 0x5F,
    IT_LOAD_CONFIG_REG                   = 0x60,
    IT_LOAD_CONTEXT_REG                  = 0x61,
    IT_LOAD_SH_REG_INDEX                 = 0x63,
    IT_LOAD_UCONFIG_REG_INDEX            = 0x64,
    IT_SET_CONFIG_REG                    = 0x68,
    IT_SET_CONTEXT_REG                   = 0x69,
    IT_SET_SH_REG                        = 0x76,
    IT_SET_SH_REG_OFFSET                 = 0x77,
    IT_SET_UCONFIG_REG                   = 0x79,
    IT_SET_UCONFIG_REG_INDEX             = 0x7A,
    IT_INDEX_ATTRIBUTES_INDIRECT         = 0x91,
    IT_WAIT_REG_MEM64                    = 0x93,
    IT_HDP_FLUSH                         = 0x95,
    IT_INVALIDATE_TLBS                   = 0x98,
    IT_DMA_DATA_FILL_MULTI               = 0x9A,
    IT_SET_SH_REG_INDEX                  = 0x9B,
    IT_LOAD_CONTEXT_REG_INDEX            = 0x9F,
    IT_DISPATCH_DIRECT_INTERLEAVED       = 0xA7,
    IT_DISPATCH_INDIRECT_INTERLEAVED     = 0xA8,
    IT_DISPATCH_TASK_STATE_INIT          = 0xA9,
    IT_DISPATCH_TASKMESH_DIRECT_ACE      = 0xAA,
    IT_DISPATCH_TASKMESH_INDIRECT_MULTI_ACE = 0xAD,
    IT_EXECUTE_INDIRECT                  = 0xAE,
    IT_BUILD_UNTYPED_SRD                 = 0xAF,
    IT_EVENT_WRITE_ZPASS                 = 0xB1,
    IT_TIMESTAMP                         = 0xB2,
    IT_EXECUTE_INDIRECT_V2               = 0xB4,
    IT_SET_CONTEXT_REG_PAIRS             = 0xB8,
    IT_SET_SH_REG_PAIRS                  = 0xBA,
    IT_SET_SH_REG_PAIRS_PACKED           = 0xBC,
    IT_SET_SH_REG_PAIRS_PACKED_N         = 0xBD,
    IT_SET_UCONFIG_REG_PAIRS             = 0xBE,
    IT_LOAD_BUFFER_FILLED_SIZES          = 0xC0,
    IT_SET_BUFFER_FILLED_SIZE            = 0xC1,
    IT_SAVE_BUFFER_FILLED_SIZES          = 0xC2,
    IT_STREAMOUT_STATS_QUERY             = 0xC3,
    IT_PROTECTED_FENCE_SIGNAL            = 0xD0,
    IT_FENCE_WAIT_MULTI                  = 0xD1,
    IT_CLEANER_SHADER                    = 0xD2,
    IT_UPDATE_DB_SUMMARIZER_TIMEOUTS     = 0xEF,
};

#define PM4_TYPE_0 0
#define PM4_TYPE_2 2
#define PM4_TYPE_3 3

#endif // PM4_IT_OPCODES_GFX12_H
